define(['angular', 'app'], function (angular, app) {
    "use strict";

    app.service('AbstractFitnessService', function ($parse, formatter, CollectionCRUDService,
        patient, localResourceDirectoryService, $filter) {

        var CollectionCRUDService = CollectionCRUDService;

        var AbstractFitnessService = function (extension) {
            var config = {},
                dateKey = extension.object.dateKey;

            var deepObjectSet = function (keys, item, value) {
                var temp = item,
                    keyArray = keys.split("."),
                    numKeys = keyArray.length;

                for(var i = 0; i < numKeys - 1; i++) {
                    if (!temp[keyArray[i]]) {
                        temp[keyArray[i]] = {};
                    }
                    temp = temp[keyArray[i]];
                }
                temp[keyArray[numKeys - 1]] = value;
            };

            config.dependency = {
                service: localResourceDirectoryService
            };

            config.collection = {
                sortComparator: [ { key: dateKey[0].from + "SortKey", reverse: true } ],
                filter: function(list, filters) {
                    if (filters === null) {
                        return list;
                    }
                    
                    var startDate = new Date(filters.startDate + " 00:00"),
                        endDate = new Date(filters.endDate + " 23:59"),
                        getter = $parse(dateKey[0].from);

                    return list.filter(function(item){
                        var itemDate = new Date(getter(item));
                        return itemDate >= startDate && itemDate <= endDate;
                    });
                }
            };

            var formatNumber = function(number, numDecimals) {
                return ($filter('number')(number, numDecimals)).replace(",", "");
            };

            config.object = {
                responseTransform: function (item) {
                    if(item.value && item.value.miles) {item.value.miles = formatNumber(item.value.miles, 1);}

                    dateKey.forEach(function(key){
                        var dateOnlyKey = key.toPrefix ? key.toPrefix + "Date" : "inputEntryDate",
                            timeOnlyKey = key.toPrefix ? key.toPrefix + "Time" : "inputEntryTime",
                            value = $parse(key.from)(item),
                            dateOnlyValue = formatter.getFormattedFrontendDate(value),
                            timeOnlyValue = formatter.getFormattedFrontendTime(value);

                        deepObjectSet(dateOnlyKey, item, dateOnlyValue);
                        deepObjectSet(timeOnlyKey, item, timeOnlyValue);
                        deepObjectSet(key.from, item, dateOnlyValue + " " + timeOnlyValue);

                        if (dateOnlyValue && timeOnlyValue) {
                            deepObjectSet(key.from + "SortKey", item, new Date(dateOnlyValue + " " + timeOnlyValue));
                        } else {
                            deepObjectSet(key.from + "SortKey", item, "");
                        }
                    });

                    return item;
                },
                requestTransform: function (item) {
                    // item.activityDate = formatter.getFormattedBackendDateTime(item.inputEntryDate + " " + item.inputEntryTime);

                    dateKey.forEach(function(key) {
                        var dateOnlyKey = key.toPrefix ? key.toPrefix + "Date" : "inputEntryDate"
                        var timeOnlyKey = key.toPrefix ? key.toPrefix + "Time" : "inputEntryTime"
                        deepObjectSet(key.from, item, formatter.getFormattedBackendDateTime($parse(dateOnlyKey)(item) + " " + $parse(timeOnlyKey)(item)));
                    });

                    !item.value.minutes && delete item.value.minutes;
                    !item.value.steps && delete item.value.steps;
                    !item.value.miles && delete item.value.miles;

                    return item;
                }
            };

            angular.element.extend(true, config, extension);

            CollectionCRUDService.call(this, config);

            this.createEmpty = function () {
                var empty = { 
                    minutes : ''
                };

                extension.object.dateKey.forEach(function(key) {
                    deepObjectSet(key.from, empty, formatter.getFormattedBackendDateTime(new Date()));
                });
            
                return this.config.object.responseTransform(angular.extend(empty, angular.copy(extension.object.defaults)));
            };

            this.fetch = function (queryParams) {
                var that = this,
                    requestPromise = that._onRequestComplete(that.BaseCRUDService.fetch(queryParams));

                requestPromise.then(function (response) {
                    that.dataPointers.filters = angular.copy(queryParams);
                    that.dataPointers.list = sort(response[that.config.collection.name], that.config.collection.sortComparator);
                    that.dataPointers.unfilteredList = angular.copy(that.dataPointers.list);
                    that.dataPointers.list = that.config.collection.filter(angular.copy(that.dataPointers.list), angular.copy(that.dataPointers.filters));
                    that.dataPointers.link = response.link;
                });
                return requestPromise;
            };
            
        };

        // ============================================
        // internal functions
        // ============================================
         var sort = function (list, sortComparator) {
            return list.sort(function (left, right) {
                var resolvedOrder = 0;
                for (var i = 0; i < sortComparator.length; i++) {
                    var getter = $parse(sortComparator[i].key),
                        leftVal = getter(left),
                        rightVal = getter(right);

                    if (angular.isString(leftVal) && angular.isString(rightVal)) {
                        leftVal = leftVal.toLowerCase();
                        rightVal = rightVal.toLowerCase();
                    }

                    if (leftVal === rightVal) {
                        resolvedOrder = 0;
                    } else {
                        if (angular.isUndefined(leftVal) && angular.isDefined(rightVal)) {
                            resolvedOrder = -1;
                        } else if (angular.isDefined(leftVal) && angular.isUndefined(rightVal)) {
                            resolvedOrder = 1;
                        } else {
                            resolvedOrder = leftVal > rightVal ? 1 : -1;
                            resolvedOrder = sortComparator[i].reverse ? -1 * resolvedOrder : resolvedOrder;
                        }
                        break;
                    }
                }
                return resolvedOrder;
            });
        };

        AbstractFitnessService.prototype = Object.create(CollectionCRUDService.prototype);
        AbstractFitnessService.prototype.constructor = AbstractFitnessService;

        return AbstractFitnessService;
    });
});